DROP INDEX ADRMGT.STATS_TABLE_100111_095852;

CREATE INDEX ADRMGT.STATS_TABLE_100111_095852 ON ADRMGT.STATS_TABLE_100111_095852
(STATID, TYPE, C5, C1, C2, 
C3, C4, VERSION)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRMGT.STATS_TAB;

CREATE INDEX ADRMGT.STATS_TAB ON ADRMGT.STATS_TAB
(STATID, TYPE, C5, C1, C2, 
C3, C4, VERSION)
LOGGING
TABLESPACE M_DATA_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRMGT.RELEASE_NUMBER_UK;

CREATE UNIQUE INDEX ADRMGT.RELEASE_NUMBER_UK ON ADRMGT.RELEASE
(RELEASE_NUMBER)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRMGT.RELEASE_ID_PK;

CREATE UNIQUE INDEX ADRMGT.RELEASE_ID_PK ON ADRMGT.RELEASE
(RELEASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRMGT.RELEASE_ID_H_PK;

CREATE UNIQUE INDEX ADRMGT.RELEASE_ID_H_PK ON ADRMGT.RELEASE_H
(RELEASE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRMGT.JOB_PROCESS_LOGS_PK;

CREATE UNIQUE INDEX ADRMGT.JOB_PROCESS_LOGS_PK ON ADRMGT.JOB_PROCESS_LOGS
(JOB_PROCESS_LOGS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRMGT.JOB_PROCESS_LOGS_NAME_NU;

CREATE INDEX ADRMGT.JOB_PROCESS_LOGS_NAME_NU ON ADRMGT.JOB_PROCESS_LOGS
(JOB_NAME, JOB_LOG_DATE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRMGT.JOB_PROCESS_ERRS_PK;

CREATE UNIQUE INDEX ADRMGT.JOB_PROCESS_ERRS_PK ON ADRMGT.JOB_PROCESS_ERRS
(JOB_PROCESS_ERRS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRMGT.JOB_PROCESS_ERRS_NAME_NU;

CREATE INDEX ADRMGT.JOB_PROCESS_ERRS_NAME_NU ON ADRMGT.JOB_PROCESS_ERRS
(JOB_NAME, JOB_ERROR_DATE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRMGT.DEPLOYMENT_ID_PK;

CREATE UNIQUE INDEX ADRMGT.DEPLOYMENT_ID_PK ON ADRMGT.DEPLOYMENT
(DEPLOYMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRMGT.DEPLOYMENT_H_ID_PK;

CREATE UNIQUE INDEX ADRMGT.DEPLOYMENT_H_ID_PK ON ADRMGT.DEPLOYMENT_H
(DEPLOYMENT_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRMGT.CONTACT_ID_PK;

CREATE UNIQUE INDEX ADRMGT.CONTACT_ID_PK ON ADRMGT.ADR_USER_CONTACT
(ADR_USER_CONTACT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRMGT.CONTACT_ID_H_PK;

CREATE UNIQUE INDEX ADRMGT.CONTACT_ID_H_PK ON ADRMGT.ADR_USER_CONTACT_H
(ADR_USER_CONTACT_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRMGT.CCR_REL_FK_I;

CREATE INDEX ADRMGT.CCR_REL_FK_I ON ADRMGT.CCR
(RELEASE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRMGT.CCR_NUMBER_UK;

CREATE UNIQUE INDEX ADRMGT.CCR_NUMBER_UK ON ADRMGT.CCR
(CCR_NUMBER)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRMGT.CCR_ID_PK;

CREATE UNIQUE INDEX ADRMGT.CCR_ID_PK ON ADRMGT.CCR
(CCR_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRMGT.CCR_H_ID;

CREATE UNIQUE INDEX ADRMGT.CCR_H_ID ON ADRMGT.CCR_H
(CCR_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRMGT.CCR_DEP_FK_I;

CREATE INDEX ADRMGT.CCR_DEP_FK_I ON ADRMGT.CCR
(DEPLOYMENT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRMGT.ADR_PARAM_H_APP_PARMNAME_NK;

CREATE INDEX ADRMGT.ADR_PARAM_H_APP_PARMNAME_NK ON ADRMGT.ADR_PARAMETER_H
(APPLICATION_NAME, PARAMETER_NAME, HISTORY_CREATED_DATE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRMGT.ADR_PARAM_APP_PARMNAME_UK;

CREATE UNIQUE INDEX ADRMGT.ADR_PARAM_APP_PARMNAME_UK ON ADRMGT.ADR_PARAMETER
(APPLICATION_NAME, PARAMETER_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRMGT.ADR_PARAMETER_ID_PK;

CREATE UNIQUE INDEX ADRMGT.ADR_PARAMETER_ID_PK ON ADRMGT.ADR_PARAMETER
(ADR_PARAMETER_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRMGT.ADR_PARAMETER_H_ID_PK;

CREATE UNIQUE INDEX ADRMGT.ADR_PARAMETER_H_ID_PK ON ADRMGT.ADR_PARAMETER_H
(ADR_PARAMETER_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
